#include <cvidef.h>

/*=================== Sorensen DCS/DLM Include File =========================*/
     
#ifndef __SNSGI_HEADER
#define __SNSGI_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)

#define VI_INSTR_WARNING_OFFSET                           (0x3FFC0900L)
#define VI_INSTR_ERROR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define SNSGI_ERROR_SYNTAX                       (VI_INSTR_ERROR_OFFSET + 0xF0L)

/*****************************************************************************/
/* Define Status Byte and Service Request Register Bits                      */
/*****************************************************************************/
#define	SNSGI_SB_PROTEVENT	0x02
#define	SNSGI_SB_ERRORQUERY	0x04
#define	SNSGI_SB_MAV			0x10
#define	SNSGI_SB_STANDEVENT	0x20
#define	SNSGI_SB_SRQ			0x40

/*****************************************************************************/
/* Define Standard Event Register Bits                                       */
/*****************************************************************************/
#define	SNSGI_SE_OPC			0x01
#define	SNSGI_SE_ERRORQUERY	0x04
#define	SNSGI_SE_DEVICEERROR	0x08
#define	SNSGI_SE_RANGEERROR	0x10
#define	SNSGI_SE_SYNTAXERROR	0x20
#define	SNSGI_SE_PWRON		0X80

/*****************************************************************************/
/* Define Protection Event and Protection Condition Register Bits            */
/*****************************************************************************/
#define	SNSGI_PE_VOLTMODE	0x01
#define	SNSGI_PE_CURRMODE	0x02
#define	SNSGI_PE_HW			0x04
#define	SNSGI_PE_OVP			0x08
#define	SNSGI_PE_OTP			0x10
#define	SNSGI_PE_EXTSD		0x20
#define	SNSGI_PE_FOLD		0x40
#define	SNSGI_PE_PRGMERROR	0X80

/*****************************************************************************/
/* Define Foldback Modes                                                     */
/*****************************************************************************/
#define	SNSGI_FB_NORMAL		0x00
#define	SNSGI_FB_VOLTMODE	0x01
#define	SNSGI_FB_CURRMODE	0x02

/*****************************************************************************/
/* Maximum time a thread will wait to gain control of the session, in        */
/* milli-seconds.															 */
/* All functions have an exclusive lock by VI session, preventing other      */
/* threads accessing the same function.                                      */
/*****************************************************************************/
#define THREAD_LOCK_TIMEOUT 7000

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus CVIFUNC SNSGI_init                   (ViRsrc         resourceName,
                                               ViBoolean      IDQuery,
                                               ViBoolean      resetDevice,
                                               ViPSession     instrSession);
                              
ViStatus CVIFUNC SNSGI_GenerateDCVolt         (ViSession      instrSession,
                                               ViReal64       voltage);
                                        
ViStatus CVIFUNC SNSGI_GenerateDCCurr         (ViSession      instrSession,
                                               ViReal64       current);

ViStatus CVIFUNC SNSGI_GeneratePower          (ViSession      instrSession,
					       ViReal64 watts);

                                        
ViStatus CVIFUNC SNSGI_GenerateDCVRamp        (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       time);
                                          
ViStatus CVIFUNC SNSGI_GenerateDCCRamp        (ViSession      instrSession,
                                               ViReal64       current,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_OutState               (ViSession      instrSession,
                                               ViBoolean      state);

ViStatus CVIFUNC SNSGI_MeasureDCVolt          (ViSession      instrSession,
                                               ViReal64       *voltage);
                                    
ViStatus CVIFUNC SNSGI_MeasureDCCurr          (ViSession      instrSession,
                                               ViReal64       *current);

ViStatus CVIFUNC SNSGI_MeasurePower   		  (ViSession instrumentHandle,
                             				   ViReal64 *powerMeasurement);

ViStatus CVIFUNC SNSGI_ModeQuery              (ViSession      instrSession,
                                               ViInt16        *mode);

ViStatus CVIFUNC SNSGI_VoltMode               (ViSession      instrSession,
                                               ViBoolean      serviceRequest);

ViStatus CVIFUNC SNSGI_CurrMode               (ViSession      instrSession,
                                               ViBoolean      serviceRequest);

ViStatus CVIFUNC SNSGI_NormalMode             (ViSession      instrSession);


ViStatus CVIFUNC SNSGI_ConfigDCVolt           (ViSession      instrSession,
                                               ViReal64       voltage);
                                          
ViStatus CVIFUNC SNSGI_ConfigDCCurr           (ViSession      instrSession,
                                               ViReal64       current);

ViStatus CVIFUNC SNSGI_ConfigDCVRamp          (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       time);
                                          
ViStatus CVIFUNC SNSGI_ConfigDCCRamp          (ViSession      instrSession,
                                               ViReal64       current,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ConfigOVP              (ViSession      instrSession,
                                               ViReal64       ovp);
                                      
ViStatus CVIFUNC SNSGI_ConfigSoftLimits       (ViSession      instruSession,
                                               ViReal64       voltage,
                                               ViReal64       current);

ViStatus CVIFUNC SNSGI_ConfigPowerOn          (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       ovp);

ViStatus CVIFUNC SNSGI_ConfigFoldback         (ViSession      instrSession,
                                               ViInt16        mode);

ViStatus CVIFUNC SNSGI_ConfigProtDelay        (ViSession      instrSession,
                                               ViReal64       delay);

ViStatus CVIFUNC SNSGI_ConfigVoltAve          (ViSession      instrSession,
                                               ViInt16        average);

ViStatus CVIFUNC SNSGI_ConfigCurrAve          (ViSession      instrSession,
                                               ViInt16        average);

ViStatus CVIFUNC SNSGI_ConfigProtEventEnable  (ViSession      instrSession,
                                               unsigned char  protectionEventEnable);

ViStatus CVIFUNC SNSGI_ConfigStandEventEnable (ViSession      instrSession,
                                               unsigned char  standardEventEnable);

ViStatus CVIFUNC SNSGI_ConfigSerReqEnable     (ViSession      instrSession,
                                               unsigned char  serviceRequestEnable);

ViStatus CVIFUNC SNSGI_OutputVoltQuery        (ViSession      instrSession,
                                               ViReal64       *voltage);
                                          
ViStatus CVIFUNC SNSGI_OutputCurrQuery        (ViSession      instrSession,
                                               ViReal64       *current);

ViStatus CVIFUNC SNSGI_OutputPowerQuery       (ViSession instrSession,
                                               ViReal64 *ProgrammedPower);

                                          
ViStatus CVIFUNC SNSGI_OutputOVPQuery         (ViSession      instrSession,
                                               ViReal64       *OVP);

ViStatus CVIFUNC SNSGI_OutStateQuery          (ViSession      instruSession,
                                               ViBoolean      *state);

ViStatus CVIFUNC SNSGI_SoftLimitsQuery        (ViSession      instrSession,
                                               ViReal64       *voltage,
                                               ViReal64       *current);

ViStatus CVIFUNC SNSGI_PowerOnQuery           (ViSession      instrSession,
                                               ViReal64       *voltage,
                                               ViReal64       *current,
                                               ViReal64       *OVP);

ViStatus CVIFUNC SNSGI_protDelayQuery         (ViSession      instrSession,
                                               ViReal64       *delay);

ViStatus CVIFUNC SNSGI_measVoltAveQuery       (ViSession      instrSession,
                                               ViInt16        *average);

ViStatus CVIFUNC SNSGI_measCurrAveQuery       (ViSession      instrSession,
 
                                               ViInt16        *average);

ViStatus CVIFUNC SNSGI_SeqInit (ViSession instrSession, ViInt16 *initialized);

ViStatus CVIFUNC SNSGI_SeqCatalog             (ViSession      instrSession,
                                               ViChar         catalog[]);

ViStatus CVIFUNC SNSGI_SeqArm (ViSession instrSession);

ViStatus CVIFUNC SNSGI_ProgVIMode                     (ViSession      instrSession,
                                               ViInt16        step,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       OVP,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ProgVoltRamp                   (ViSession      instrSession,
                                               ViInt16        step,
                                               ViReal64       voltage,
                                               ViReal64       voltage_final,
                                               ViReal64       current,
                                               ViReal64       OVP,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ProgCurrRamp                   (ViSession      instrSession,
                                               ViInt16        step,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       current_final,
                                               ViReal64       OVP,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ProgPowerMode                  (ViSession      instrSession,
                                               ViInt16        step,
                                               ViReal64       power,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       OVP,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ProgRepeat                     (ViSession      instrSession,
                                               ViInt16        step);

ViStatus CVIFUNC SNSGI_ProgCall                       (ViSession      instrSession,
                                               ViInt16        step,
                                               ViChar         sequence[]);

ViStatus CVIFUNC SNSGI_ProgReturn                     (ViSession      instrSession,
                                               ViInt16        step);

ViStatus CVIFUNC SNSGI_ProgLoop                       (ViSession      instrSession,
                                               ViInt16        step,
                                               unsigned int   loop);

ViStatus CVIFUNC SNSGI_ProgNext                       (ViSession      instrSession,
                                               ViInt16        step);

ViStatus CVIFUNC SNSGI_ProgStop                       (ViSession      instrSession,
                                               ViInt16        step);

ViStatus CVIFUNC SNSGI_ProgGoto                       (ViSession      instrSession,
                                               ViInt16        step,
                                               ViChar         sequence[]);

ViStatus CVIFUNC SNSGI_ProgPause                      (ViSession      instrSession,
                                               ViInt16        step);

ViStatus CVIFUNC SNSGI_ProgNOP (ViSession instrumentSession, ViInt16 step);


ViStatus CVIFUNC SNSGI_ProgDefineQuery                (ViSession      instrSession,
                                               ViInt16        step,
                                               ViChar         settings[]);

ViStatus CVIFUNC SNSGI_ProgDeleteSelected             (ViSession      instrSession);

ViStatus CVIFUNC SNSGI_ProgDeleteAll                  (ViSession      instrSession);

ViStatus CVIFUNC SNSGI_ImmExeVI                       (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       current,
                                               ViReal64       OVP);

ViStatus CVIFUNC SNSGI_ImmExeVoltRamp                 (ViSession      instrSession,
                                               ViReal64       voltage,
                                               ViReal64       voltage_final,
                                               ViReal64       current,
                                               ViReal64       OVP,
                                               ViReal64       time);

ViStatus CVIFUNC SNSGI_ImmExeCurrRamp (ViSession instrSession, ViReal64 voltage,
                               ViReal64 current,ViReal64 current_final, ViReal64 OVP, ViReal64 time);

ViStatus CVIFUNC SNSGI_ImmExePowerMode (ViSession instrSession, ViReal64 voltage,
                                ViReal64 current, ViReal64 OVP, ViReal64 power);

ViStatus CVIFUNC SNSGI_ProgMemAlloc (ViSession instrSession);

ViStatus CVIFUNC SNSGI_ProgName (ViSession instrSession, ViChar name[]);

ViStatus CVIFUNC SNSGI_ProgNameChan (ViSession instrumentHandle, ViChar name[], int chan);

ViStatus CVIFUNC SNSGI_ProgNameQuery (ViSession instrSession, ViChar name[]);

ViStatus CVIFUNC SNSGI_ProgSaveSelected (ViSession instrSession);

ViStatus CVIFUNC SNSGI_ProgSaveAll (ViSession instrumentHandle);

ViStatus CVIFUNC SNSGI_ProgState (ViSession instrSession, ViChar name[]);

ViStatus CVIFUNC SNSGI_ProgStateQuery (ViSession instrSession, ViInt16 *state);

ViStatus CVIFUNC SNSGI_SeqWait (ViSession instrSession, ViInt16 step,
                        ViChar sequence[]);

ViStatus CVIFUNC SNSGI_SeqTrig (ViSession instrSession);

                                       
ViStatus CVIFUNC SNSGI_SendSWTrigger          (ViSession      instrSession,
                                               ViInt16        triggerType);
                                          
ViStatus CVIFUNC SNSGI_AbortTrigger           (ViSession      instrSession);

ViStatus CVIFUNC SNSGI_StatusByteQuery        (ViSession      instrSession,
                                               unsigned char  *statusByte,
                                               ViChar _VI_FAR statusMessage[]);
                                          
ViStatus CVIFUNC SNSGI_StandEventQuery        (ViSession      instrSession,
                                               unsigned char  *standardEventStatusRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_StandEventEnableQuery  (ViSession      instrSession,
                                               unsigned char  *standardEventEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_ProtEventQuery         (ViSession      instrSession,
                                               unsigned char  *protEventReg,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_ProtEventEnableQuery   (ViSession      instrSession,
                                               unsigned char  *protEventEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_ProtCondQuery          (ViSession       instrSession,
                                               unsigned char  *protCondReg,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_ServiceReqEnableQuery  (ViSession      instrSession,
                                               unsigned char  *serviceReqEnableRegister,
                                               ViChar _VI_FAR statusMessage[]);

ViStatus CVIFUNC SNSGI_reset                  (ViSession      instrSession);

ViStatus CVIFUNC SNSGI_clear                  (ViSession      instrSession);

ViStatus CVIFUNC SNSGI_errorQuery             (ViSession      instrSession,
                                               ViPInt32       errorCode,
                                               ViChar _VI_FAR errorMessage[]);
                                    
ViStatus CVIFUNC SNSGI_errorMessage           (ViSession      instrSession,
                                               ViStatus       statusCode,
                                               ViChar _VI_FAR message[]);
                                      
ViStatus CVIFUNC SNSGI_revisionQuery          (ViSession      instrSession,
                                               ViChar _VI_FAR driverRev[],
                                               ViChar _VI_FAR instrRev[]);
                                          
ViStatus CVIFUNC SNSGI_idQuery                (ViSession      instrSession,
                                               ViChar _VI_FAR idBuffer[]);
                                 
ViStatus CVIFUNC SNSGI_ModelQuery             (ViSession      instrSession,
                                               ViReal64       *modelVolt,
                                               ViReal64       *modelCurr);
                                          
ViStatus CVIFUNC SNSGI_close                  (ViSession      instrSession);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
